#!/usr/bin/perl
#
# Add "Include /usr/apache/conf.d" to /usr/apache/conf/httpd.conf

my $conf = "/usr/apache/conf/httpd.conf";
my $confdir = "/usr/apache/conf.d";

system("mkdir -p $confdir") == 0 || die;

my $t = "$confdir/nothing.conf";

if ( !( -e "$t" ) ) {
    open(X,">",$t) || die;
    close(X);
}

my $do_patch = 1;

open(X,"<",$conf) || die;
while (my $line = <X>) {
    chomp $line;

    # NTS: We look for the statement in such a way that it matches no matter how many spaces.
    #      We also match it whether there is a pound sign at the start (commented out) so that
    #      if the user comments it out we don't add it again.
    if ($line =~ m/^[ \t\#]*[ \t]*include[ \t+]conf\.d\/\*\.conf[ \t]*$/i) {
        print "Include statement already in file\n";
        $do_patch = 0;
    }
}
close(X);

exit 0 if $do_patch == 0;

print "Patching $conf\n";

# append
open(X,">>",$conf) || die;
print X "\n";
print X "#Added by Castus update\n";
print X "Include conf.d/*.conf\n";
print X "\n";
close(X);

