#!/usr/bin/perl
#
# Add "Include /usr/apache/conf.d" to /usr/apache/conf/httpd.conf

my $conf = "/usr/apache/conf/httpd-ssl.conf";
my $confdir = "/usr/apache/conf.d";

system("mkdir -p $confdir") == 0 || die;

my $t = "$confdir/nothing.conf";

if ( !( -e "$t" ) ) {
    open(X,">",$t) || die;
    close(X);
}

my $in_vhost = 0;
my $do_patch = 1;
my $newfile = '';

open(X,"<",$conf) || die;
while (my $line = <X>) {
    chomp $line;

    if ($in_vhost == 1) {
        if ($line =~ m/^[ \t]*\<\/VirtualHost[ \t]*\>/i) {
            if ($do_patch) {
                $newfile .= "\n";
                $newfile .= "#Added by Castus update\n";
                $newfile .= "Include conf.d/*.conf\n";
                $newfile .= "\n";
            }
            $in_vhost = 2;
        }
    }
    elsif ($in_vhost == 0) {
        if ($line =~ m/^[ \t]*\<VirtualHost[ \t]+_default_:443\>/i) {
            $in_vhost = 1;
        }
    }

    $newfile .= "$line\n";

    # NTS: We look for the statement in such a way that it matches no matter how many spaces.
    #      We also match it whether there is a pound sign at the start (commented out) so that
    #      if the user comments it out we don't add it again.
    if ($in_vhost == 1 && $line =~ m/^[ \t\#]*[ \t]*include[ \t+]conf\.d\/\*\.conf[ \t]*$/i) {
        print "Include statement already in file\n";
        $do_patch = 0;
    }
}
close(X);

system("rm -f /usr/apache/conf.d/service-control-api.ssl.conf"); # <- that was a mistake

exit 0 if $do_patch == 0;

print "Patching $conf\n";

# append
open(X,">",$conf) || die;
print X $newfile;
close(X);

